
//
// Copyright Seagate Software, 2000
//

var _bver    = parseInt(navigator.appVersion);
var Nav4     = ((navigator.appName == "Netscape") && _bver==4);
var Nav4plus = ((navigator.appName == "Netscape") && _bver>=4);
var Nav5plus = ((navigator.appName == "Netscape") && _bver>=5);
var IE4plus  = ((navigator.userAgent.indexOf("MSIE") != -1) && _bver>=4);
var IE5plus  = ((navigator.userAgent.indexOf("MSIE 5.0") != -1) && _bver>=4);
    

//strings that need localization - don't localize anything not listed here


//////////////////////////////////////////////
// variables used to hold the current state of the viewer
var currentPage			= 1;
var totalPageCount		= 0;
var currentBRCH			= null;
var currentDrillDown	= "";
var currentSubRPT       = "";
var GrouptreeFrameWidth = null;
var hasGroupTree        = true;     //whether or not a grouptree is going to be generated (not the same as hidden)

////////////////////////////////////////////////
// gotoPage : sets the current report page to the value given
// pageNumber - Required. The page number you wish to go to. Use -1 to go to the last page of the report.
function gotoPage ( pageNumber )
{
	var req;
	if ( pageNumber == -1 )
		req = buildLastPageRequest ( currentBRCH, currentSubRPT );
	else
		req = buildPageRequest ( pageNumber, currentBRCH, null, currentSubRPT );
	self.frames["CrystalViewerPreview"].frames["CrystalViewerPage"].location = req;
}

////////////////////////////////////////////////
// showGrouptree : makes a hidden grouptree visible
// Note: on Netscape this will require a round trip to the server to do a page reload
function toggleGrouptree ()
{
    if ( hasGroupTree) {
	    if ( GrouptreeFrameWidth == "15%" )
		    GrouptreeFrameWidth = "0";
	    else
		    GrouptreeFrameWidth = "15%";
	    if ( Nav4 )
		    self.frames["CrystalViewerPreview"].document.location.reload ();
	    else
		    self.frames["CrystalViewerPreview"].document.body.cols = (GrouptreeFrameWidth + ",*");
    }
}

////////////////////////////////////////////////
// refresh : data will be refreshed
// Note: this will NOT reset the current page to page 1. In order to behave like Java and Actx
// viewers, the current page will be used, but if we have a drilldown then we'll go to the first
// page (which is unlike the other viewers)
function doRefresh ()
{
    //if we are in drilldown or subreport, we'll go back to page 1
    if ( currentBRCH != null && currentBRCH != "" )
        currentPage = 1;
    if ( currentSubRPT != null && currentSubRPT != "" )
        currentPage = 1;
    totalPageCount = 0;
    currentBRCH    = null;
    currentSubRPT  = null;
    if ( self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"] != null )
    {
	    self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"].document.write("<html><body></body></html>");
	    self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"].document.close();
    }
	var req = buildRefreshRequest ();
	self.frames["CrystalViewerPreview"].frames["CrystalViewerPage"].location.replace ( req );
}

//////////////////////////////////////////
// doTextSearch : 
// searchText: Required. The text string you want to search for.
function doTextSearch ( searchText )
{
	var req = buildSearchRequest (escape(searchText));
	self.frames["CrystalViewerPreview"].frames["CrystalViewerPage"].location = req;
}

//////////////////////////////////////////////
// setDrillDownLevel
// brch    - Required. The current drilldown branch. This will be given in the "onReportPageLoad" event.
// drillname - Required. The name of the current drilldown group or on demand subreport name. This will be given in the "onReportPageLoad" event.
// subrpt  - Optional. The current on demand sub-report identifier. This will be given in the "onReportPageLoad" event.
// page    - Optional. The page in the drill down that is wanted.
function setDrillDownLevel ( brch, drillname, subrpt, page )
{
	var _subrpt = "", _page = 1;
	if ( setDrillDownLevel.arguments.length > 2 ) {
		_subrpt = subrpt;
		if ( setDrillDownLevel.arguments.length > 3 )
			_page = page;
	}
	req = buildPageRequest ( _page, brch, drillname, _subrpt );
	self.frames["CrystalViewerPreview"].frames["CrystalViewerPage"].location = req;
}

////////////////////////////////////////////////////////////
//helper functions - functions below here should not be called directly

/////////////////////////////////////////////////
// registerPageLoad : called by report page when it loads to set current state information
//pageN   - page that was loaded
//TPageN  - last page, 0 if last page isn't known
//brch    - current drill down branch (e.g. 0-2 is first group's third group)
//drillName - name of current drilldown (group name or on demand subreport name)
//subrpt  - for on demand suprpts the current subrpt identifier
function registerPageLoad ( pageN, TPageN, brch, drillName, subrpt )
{

	if ( self.frames["CrystalViewerToolbar"].onReportPageLoad != null )
		self.frames["CrystalViewerToolbar"].onReportPageLoad ( pageN, TPageN, brch, drillName, subrpt );
    if ( self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"] != null )
    {
	    if ( currentBRCH != brch || currentSubRPT != subrpt || self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"].isLoading )
	    {
		    var treeReq = buildGrouptreeRequest ( brch, subrpt );
            if ( self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"] )
		        self.frames["CrystalViewerPreview"].frames["CrystalViewerTree"].location = treeReq;
	    }
    }
    //always update current state last
	currentPage	     = pageN;
	totalPageCount	 = TPageN;
	currentBRCH      = brch;
    currentSubRPT    = subrpt;
    currentDrillDown = drillName;
}

function buildPageRequest ( page, brch, drillName, subrpt )
{
	var result = getHREF ( brch, subrpt );
	var grp = ""
	if ( drillName )
		grp = "&drillName=" + escape(drillName);
	return result + "&cmd=get_pg&incomplete_page_count=1&page=" + page + grp;
}
function buildLastPageRequest ( brch, subrpt )
{
	var result = getHREF ( brch, subrpt );
	return result + "&cmd=get_lpg&incomplete_page_count=1";
}
function buildGrouptreeRequest ( brch, subrpt )
{
	var result = getHREF ( brch, subrpt );
	return result + "&cmd=get_ttl";
}
function buildRefreshRequest ( )
{
	var result = getHREF (null,null);
	return result + "&cmd=rfsh&incomplete_page_count=1&page=" + currentPage;
}
function buildSearchRequest ( text ) 
{
	var result = getHREF ();
	return result + "&cmd=srch&incomplete_page_count=1&dir=FOR&case=0&page=" + (currentPage+1) + "&text=" + text;
}
function buildExportRequest ( format )
{
    var result = getHREF (null, null);  //don't want brch or subrpt as we don't support exporting either
    return result + "&cmd=export&export_fmt="+escape(format);

}
function getID ()
{
	var qArray = self.frames["CrystalViewerPreview"].location.search.toLowerCase().split ('&');
	var id = "";
	for ( idx = 0; idx < qArray.length; ++idx )
	{
		if ( qArray[idx].indexOf ("id=") != -1 )
			id = qArray[idx].substr ( "id=".length );
	}
	if ( id != "" )
		id = ("&id=" + id);
	return id;
}
function getHREF ( given_brch, given_subrpt )
{
    var viewerPreviewLoc = self.frames["CrystalViewerPreview"].location;
	var id = getID ();
	var result = viewerPreviewLoc.href;
	if ( viewerPreviewLoc.href.indexOf ("?") != -1 )
		result = viewerPreviewLoc.href.slice ( 0, viewerPreviewLoc.href.indexOf ("?") );
    //brch
    var brch = "&brch=";
    if ( getHREF.arguments.length == 0 )   //if no brch given add in current
        brch += (currentBRCH!=null) ? currentBRCH : "";
    else
        brch += (given_brch!=null) ? given_brch : "";
    //subrpt
    var subRPT = "";
    if ( getHREF.arguments.length == 2 )
        subRPT = (given_subrpt) ? ("&subrpt=" + given_subrpt) : "";
    else
        subRPT = (currentSubRPT) ? ("&subrpt=" + currentSubRPT) : "";
	
	return (result + "?viewer=html_frame" + id + brch + subRPT);
}
